#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_BloodUnitFinance : BaseTest 
	{
		
		private DataTable _dtFinance;
		private DataTable _dtBloodUnit;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtFinance = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitFinance WHERE BloodUnitGuid IN (SELECT TOP 1 BloodUnitGuid FROM vw_BloodShipFinanceAllCurrent WHERE OutgoingShipmentGuid IN (SELECT ShipmentGuid FROM Shipment WHERE ShipmentDate IS NULL) AND RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "')", true);

				//Get the BloodUnit Information*********************************************
				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM BloodUnit WHERE BloodUnitGuid = '" + this._dtFinance.Rows[0][TABLES.BloodUnit.BloodUnitGuid].ToString() + "'", true);

				this.RefreshData = false;
			}

		}

		[Test]
		public void GetEmptyBloodUnitFinanceTableSchema_Pass()
		{
			DataTable dtTest = DAL.BloodUnitFinance.GetEmptyBloodUnitFinanceTableSchema(true);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.BloodUnitFinanceGuid), TABLES.BloodUnitFinance.BloodUnitFinanceGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.UnitCost), TABLES.BloodUnitFinance.UnitCost);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.ReturnCreditAmount), TABLES.BloodUnitFinance.ReturnCreditAmount);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.SpecialTestingCost), TABLES.BloodUnitFinance.SpecialTestingCost);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.RowVersion), TABLES.BloodUnitFinance.RowVersion);
		}

		[Test]
		public void GetEmptyBloodUnitFinanceTableSchema_Fail()
		{
			DataTable dtTest = DAL.BloodUnitFinance.GetEmptyBloodUnitFinanceTableSchema(false);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.BloodUnitFinanceGuid), TABLES.BloodUnitFinance.BloodUnitFinanceGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.UnitCost), TABLES.BloodUnitFinance.UnitCost);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.ReturnCreditAmount), TABLES.BloodUnitFinance.ReturnCreditAmount);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.SpecialTestingCost), TABLES.BloodUnitFinance.SpecialTestingCost);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.BloodUnitGuid), TABLES.BloodUnitFinance.BloodUnitGuid);
		}

		[Test]
		public void GetBloodUnitFinancialData_Pass()
		{
			string unitID = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.EyeReadableUnitId].ToString();
			string productCode = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.UnitProductCode].ToString();

			DataRow drTest = DAL.BloodUnitFinance.GetBloodUnitFinancialData(unitID, productCode);

			Assert.AreEqual(3, drTest.Table.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.BloodUnitFinance.UnitCost), TABLES.BloodUnitFinance.UnitCost);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.BloodUnitFinance.SpecialTestingCost), TABLES.BloodUnitFinance.SpecialTestingCost);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.BloodUnitFinance.ReturnCreditAmount), TABLES.BloodUnitFinance.ReturnCreditAmount);
		}

		[Test]
		public void GetBloodUnitFinancialData_Fail()
		{
			DataRow drTest = DAL.BloodUnitFinance.GetBloodUnitFinancialData(string.Empty, string.Empty);

			//Returns a new row on NOTFOUND with empty string
			Assert.AreEqual(string.Empty, drTest[TABLES.BloodUnitFinance.UnitCost].ToString(), TABLES.BloodUnitFinance.UnitCost);
			Assert.AreEqual(string.Empty, drTest[TABLES.BloodUnitFinance.SpecialTestingCost].ToString(), TABLES.BloodUnitFinance.SpecialTestingCost);
			Assert.AreEqual(string.Empty, drTest[TABLES.BloodUnitFinance.ReturnCreditAmount].ToString(), TABLES.BloodUnitFinance.ReturnCreditAmount);


			//No unit id should return > 1 row, so this should explode with a DAL exception
			//TODO:  is a BUG in VBECS code.. empty UnitId, which should never happen, will cause an unhandled SQL exception
			//because productcode will be supplied twice as a parameter
			try
			{
				drTest = DAL.BloodUnitFinance.GetBloodUnitFinancialData(string.Empty, "04020");
				Assert.IsTrue(false, "BUG IN CODE");
			}
			catch(Exception)
			{
				Assert.IsTrue(true, "BUG IN CODE");
			}

//
//			//Catch empty product code  - neede 2 units, with same id, diff code -- big setup
//			try
//			{
//				DataRow drTemp = UnitTestUtil.RunSQLGetDataRow("SELECT DISTINCT TOP 1 EyeReadableUnitId, DivisionCode FROM vw_BloodShipFinanceAllCurrent GROUP BY EyeReadableUnitId, DivisionCode HAVING COUNT(*) > 1");
//				string unitId = drTemp[0].ToString();
//
//				drTest = DAL.BloodUnitFinance.GetBloodUnitFinancialData(unitId, string.Empty);
//				Assertion.IsTrue("DataAccessLayerException Expected", false);
//			}
//			catch(DataAccessLayerException)
//			{
//				Assertion.IsTrue("Empty Product Code", true);
//			}
		}

		[Test]
		public void IsBloodUnitOnPendingOutgoingShipmentList_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtFinance.Rows[0][TABLES.BloodUnitFinance.BloodUnitGuid];

			bool retValue = DAL.BloodUnitFinance.IsBloodUnitOnPendingOutgoingShipmentList(unitGuid);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		public void IsBloodUnitOnPendingOutgoingShipmentList_Fail()
		{
			bool retValue = DAL.BloodUnitFinance.IsBloodUnitOnPendingOutgoingShipmentList(System.Guid.NewGuid());
			
			Assert.AreEqual(false, retValue, "ReturnValue");
		}

		[Test]
		public void GetFinancialBloodUnits_Pass()
		{
			DataTable dtTest = DAL.BloodUnitFinance.GetFinancialBloodUnits();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(43, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh); 
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode); 
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetFinancialBloodUnits_Fail()
		{
		}

		[Test]
		public void GetBloodUnitFinanceByUnitGuid_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtFinance.Rows[0][TABLES.BloodUnitFinance.BloodUnitGuid];

			DataTable dtTest = DAL.BloodUnitFinance.GetBloodUnitFinanceByUnitGuid(unitGuid);

			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(9, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.BloodUnitFinanceGuid), TABLES.BloodUnitFinance.BloodUnitFinanceGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.BloodUnitGuid), TABLES.BloodUnitFinance.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.UnitCost), TABLES.BloodUnitFinance.UnitCost);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.SpecialTestingCost), TABLES.BloodUnitFinance.SpecialTestingCost);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.ReturnCreditAmount), TABLES.BloodUnitFinance.ReturnCreditAmount);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.OutgoingShipmentGuid), TABLES.BloodUnitShipment.OutgoingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.LastUpdateUser), TABLES.BloodUnitFinance.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.RowVersion), TABLES.BloodUnitFinance.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.LastUpdateDate), TABLES.BloodUnitFinance.LastUpdateDate);
		}

		[Test]
		public void GetBloodUnitFinanceByUnitGuid_Fail()
		{
			DataTable dtTest = DAL.BloodUnitFinance.GetBloodUnitFinanceByUnitGuid(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void Save_Pass()
		{
			this.RefreshData = true;

			DataTable dtBUF = DAL.BloodUnitFinance.GetEmptyBloodUnitFinanceTableSchema(true);

			BOL.BloodUnitFinance tmpBUF = new BOL.BloodUnitFinance((System.Guid)this._dtFinance.Rows[0][TABLES.BloodUnitFinance.BloodUnitGuid]);
			tmpBUF.ReturnCreditAmount = (decimal)new Random().Next(111,9999);

			dtBUF.Rows.Add(tmpBUF.LoadDataRowFromThis(dtBUF.NewRow()));

			Common.Utility.AppendLastUpdateInformation(dtBUF, Common.UpdateFunction.UnitTests);

			bool retValue = DAL.BloodUnitFinance.Save(dtBUF.Rows[0]);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void Save_Fail()
		{
			this.RefreshData = true;

			DataTable dtBUF = DAL.BloodUnitFinance.GetEmptyBloodUnitFinanceTableSchema(true);

			BOL.BloodUnitFinance tmpBUF = new BOL.BloodUnitFinance((System.Guid)this._dtFinance.Rows[0][TABLES.BloodUnitFinance.BloodUnitGuid]);
			tmpBUF.ReturnCreditAmount = (decimal)new Random().Next(111,9999);

			dtBUF.Rows.Add(tmpBUF.LoadDataRowFromThis(dtBUF.NewRow()));
			dtBUF.Rows[0][TABLES.BloodUnitFinance.RowVersion] = new byte[8];

			Common.Utility.AppendLastUpdateInformation(dtBUF, Common.UpdateFunction.UnitTests);

			DAL.BloodUnitFinance.Save(dtBUF.Rows[0]);
		}

	}
}
#endif


